<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY CDA-Stylesheet '-//HL7//XSL HL7 V1.1 CDA Stylesheet: 2000-08-03//EN'>
]>
<!-- Format of timeinterval: YYYYMMDDHHMMSS.S..YYYYMMDDHHMMSS.S, agreed 26.9.2002-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes" version="4.01" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
	<xsl:variable name="docType" select="/levelone/clinical_document_header/document_type_cd/@DN"/>
	<xsl:variable name="orgName" select="/levelone/clinical_document_header/originating_organization/organization/organization.nm/@V"/>
	<xsl:variable name="title">
		<!-- removed organization name 9.6.2002 TItala-->
		<!--<xsl:value-of select="$orgName"/>
		<xsl:text/>-->
		<xsl:value-of select="$docType"/>
	</xsl:variable>
	<xsl:template match="/levelone">
		<html>
			<head>
				<meta name="Generator" content="&CDA-Stylesheet;"/>
				<xsl:comment>
				do NOT edit this HTML directly, it was generated
				via an XSLT transformation from the original Level 1
				document.
			</xsl:comment>
				<style>
					<xsl:comment>
					body {background-color: white; color: black; }
					<!--div div { margin: 4px 0 4px 0.1in; padding: 0; }-->
						<!--ul { margin: -4px 0 -8px 0 ; padding: 0; }-->
					p { margin: 10px 0 10px 0.25in; }
					div.caption { font-weight: bold; text-decoration: underline; }
					span.caption { font-weight: bold; }
					div.title { font-size: 18pt; font-weight: bold }
					div.demographics { text-align: center ; }
				</xsl:comment>
				</style>
				<title>
					<xsl:value-of select="$title"/>
				</title>
			</head>
			<body>
				<div class="title">
					<xsl:value-of select="$title"/>
				</div>
				<br/>
				<xsl:apply-templates select="clinical_document_header"/>
				<br/>
				<xsl:apply-templates select="body"/>
				<xsl:call-template name="signature"/>
			</body>
		</html>
	</xsl:template>
	<!--
     generate a table at the top of the document containing
	 encounter and patient information.  Encounter info is
	 rendered in the left column(s) and patient info is
	 rendered in the right column(s).
	 
	 This assumes several things about the source document which
	 won't be true in the general case:
	 
	 	1. there is only 1 of everything (i.e., physcian, patient, etc.)
		2. I haven't bothered to map all HL7 table values
		   (e.g., actor.type_cd and administrative_gender_cd)
		   and have only those that are used in the sample document
		
		I tried to do the table formting with CSS2 rules, but Netscape
		doesn't seem to handle the table rules well (or at all:-( so I
		just gave up
  -->
	<xsl:template match="clinical_document_header">
		<!-- removed div demographics 9.6.2002 TItala-->
		<!--	<div class="demographics"> -->
		<table border="0">
			<tbody>
				<!-- removed encounter from this place
		added organization 9.6.2002 TItala-->
				<!--<xsl:call-template name="encounter"/> -->
				<xsl:call-template name="patient"/>
				<xsl:call-template name="organization"/>
				<xsl:call-template name="encounter"/>
			</tbody>
		</table>
		<!--</div>-->
	</xsl:template>
	<!-- added template "organization" 9.6.2002 TItala -->
	<xsl:template name="organization">
		<tr>
			<th align="left">Toimipiste: </th>
			<td>
				<xsl:value-of select="originating_organization/organization/organization.nm/@V"/>
			</td>
		</tr>
	</xsl:template>
	<!-- 5.12.2001 JIL
	Muutettu		provider elementti ksiteln eksplisiittisesti,
-->
	<xsl:template name="encounter">
		<th align="left" width="50">Ajankohta: </th>
		<td align="left">
			<xsl:call-template name="do_encounter_tmr"/>
		</td>
		<tr>
			<xsl:call-template name="do_provider"/>
		</tr>
	</xsl:template>
	<!-- 5.12.2001 JIL
	Muutettu		encounter_tmr telmplate do_encounter_tmr:ksi, jotta encounter_tmr elementti ei en
					implisiittisesti ksiteltisi. Ks. organization
-->
	<xsl:template name="do_encounter_tmr">
		<xsl:call-template name="date">
			<xsl:with-param name="date" select="patient_encounter/encounter_tmr/@V"/>
		</xsl:call-template>
	</xsl:template>
	<!-- 5.12.2001 JIL
	Muutettu		provider telmplate do_providek:ksi, jotta provider elementti ei en
					implisiittisesti ksiteltisi. Ks. organization Ks. encounter
-->
	<xsl:template name="do_provider">
		<th align="left" width="50">Ammattilainen:</th>
		<td align="left">
			<xsl:for-each select="provider/person">
				<xsl:call-template name="getName"/>
			</xsl:for-each>
		</td>
	</xsl:template>
	<!-- removed 9.6.2002 TItala-->
	<!--
	<xsl:template name="encounter">
		<tr>
			<xsl:apply-templates select="provider"/>
		</tr>
		<tr>
			<xsl:apply-templates select="patient_encounter/encounter_tmr"/>
		</tr>
	</xsl:template>
	
	<xsl:template match="encounter_tmr">
		<th align="left" width="100">Date:</th>
		<td align="left" width="140">
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="@V"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	
	<xsl:template match="provider">
		<th align="left" width="100">
			<xsl:call-template name="provider_type_cd">
				<xsl:with-param name="type_cd" select="provider.type_cd/@V"/>
			</xsl:call-template>
			<xsl:text>:</xsl:text>
		</th>
		<td align="left" width="140">
			<xsl:variable name="ptr" select="person/id/@EX"/>
			<xsl:for-each select="/levelone/clinical_document_header/originator/person[id/@EX=$ptr]">
				<xsl:call-template name="getName"/>
			</xsl:for-each>
		</td>
	</xsl:template>-->
	<xsl:template name="patient">
		<!-- removed table rows from here, removed birth_dttm from here 9.6.2002 TItala -->
		<!--<tr>-->
		<xsl:apply-templates select="patient"/>
		<!--</tr>-->
		<!--<tr>
			<xsl:apply-templates select="patient/birth_dttm"/>
		</tr>-->
	</xsl:template>
	<xsl:template match="birth_dttm">
		<th align="left" width="100">Birthdate:</th>
		<td align="left" width="140">
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="@V"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!-- reformatted patient output 9.6.2002 TItala -->
	<!--
	<xsl:template match="patient">
		<th align="left" width="100">Patient:</th>
		<td align="left" width="140">
			<xsl:for-each select="person">
				<xsl:call-template name="getName"/>
			</xsl:for-each>
		</td>
		<th align="right" width="100">
			<xsl:text>MRN:</xsl:text>
		</th>
		<td align="left" width="140">
			<xsl:value-of select="person/id/@EX"/>
		</td>
		<th align="right" width="100">Sex:</th>
		<td align="left" width="140">
			<xsl:call-template name="administrative_gender_cd">
				<xsl:with-param name="gender_cd" select="administrative_gender_cd/@V"/>
			</xsl:call-template>
		</td>
	</xsl:template>-->
	<xsl:template match="patient">
		<tr>
			<th align="left" width="50">
				<xsl:text>Hetu: </xsl:text>
			</th>
			<td align="left" colspan="3">
				<xsl:value-of select="person/id/@EX"/>
				<xsl:text>, </xsl:text>
				<xsl:call-template name="administrative_gender_cd">
					<xsl:with-param name="gender_cd" select="administrative_gender_cd/@DN"/>
				</xsl:call-template>
			</td>
		</tr>
		<tr>
			<th align="left" width="50">Asiakas: </th>
			<td align="left" colspan="3">
				<xsl:for-each select="person">
					<xsl:call-template name="getName"/>
				</xsl:for-each>
			</td>
		</tr>
	</xsl:template>
	<!--
    just apply the default template for these
  -->
	<xsl:template match="body|caption|content">
		<xsl:apply-templates/>
	</xsl:template>
	<!--
    spit out the caption (in the 'caption' style)
	followed by applying whatever templates we
	have for the applicable children
  -->
	<xsl:template match="section">
		<div>
			<div class="caption">
				<xsl:apply-templates select="caption"/>
			</div>
			<xsl:apply-templates select="paragraph|list|table|section"/>
		</div>
	</xsl:template>
	<xsl:template match="section/section">
		<ul>
			<ul>
				<!--<li>-->
				<span class="caption">
					<xsl:apply-templates select="caption"/>
					<!--<xsl:text> :: </xsl:text>-->
				</span>
				<xsl:apply-templates select="paragraph|list|table|section"/>
				<!--</li>-->
			</ul>
		</ul>
	</xsl:template>
	<!--
    currently ignores paragraph captions...
	
	I need samples of the use description and render
	to know what really should be done with them
  -->
	<xsl:template match="paragraph">
		<br/>
		<span class="caption">
			<xsl:apply-templates select="caption"/>
			<!-- xsl:text> :: </xsl:text -->
		</span>
		<xsl:apply-templates select="content"/>
	</xsl:template>
	<!--
	<xsl:template match="paragraph">
		<p>
			<xsl:apply-templates select="content"/>
		</p>
	</xsl:template>
-->
	<!--
    currently ignore caption's on the list itself,
	but handles them on the list items
  -->
	<xsl:template match="list">
		<ul>
			<xsl:for-each select="item">
				<li>
					<xsl:if test="caption">
						<xsl:apply-templates select="caption"/>
						<xsl:text> :: </xsl:text>
					</xsl:if>
					<xsl:apply-templates select="content"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<!--
    currently ignore caption's on the list itself,
	but handles them on the list items
  -->
	<xsl:template match="section/section/list">
		<xsl:for-each select="item">
			<xsl:apply-templates select="content"/>
			<xsl:if test="position()!=last()">
				<xsl:text>; </xsl:text>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="section/section/paragraph">
		<span>
			<xsl:apply-templates/>
			<br/>
		</span>
	</xsl:template>
	<!-- 
     Tables
	 
     just copy over the entire subtree, as is
	 except that the children of CAPTION are possibly handled by
	 other templates in this stylesheet
  -->
	<xsl:template match="table|table/caption|thead|tfoot|tbody|colgroup|col|tr|th|td">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="table/@*|thead/@*|tfoot/@*|tbody/@*|colgroup/@*|col/@*|tr/@*|th/@*|td/@*">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
<xsl:template match='th'>
	<th align="left">
		<xsl:apply-templates/>
	</th>
</xsl:template>

<xsl:template match='table'>
<!--  Tables forced no borders and width = 100%, TI 10.4.2002-->
	<table border="0" width="100%">
		<xsl:apply-templates/>
	</table>
</xsl:template>
<xsl:template match='table/caption'>
	<h3>
		<xsl:apply-templates/>
	</h3>
</xsl:template>

	
	<!--
     this currently only handles GIF's and JPEG's.  It could, however,
	 be extended by including other image MIME types in the predicate
	 and/or by generating <object> or <applet> tag with the correct
	 params depending on the media type
  -->
	<xsl:template match="observation_media">
		<xsl:if test='observation_media.value[
			@MT="image/gif" or @MT="image/jpeg"
			]'>
			<br clear="all"/>
			<xsl:element name="img">
				<xsl:attribute name="src">
				file:///c:/hl7%20tutorial/adv%20xml/part4/ex2/<xsl:value-of select="observation_media.value/REF/@V"/></xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!--
	turn the link_html subelement into an HTML a element,
	complete with any attributes and content it may have,
	while stripping off any CDA specific attributes
  -->
	<xsl:template match="link">
		<xsl:element name="a">
			<xsl:for-each select="link_html/@*">
				<xsl:if test='not(name()="originator" or name()="confidentiality")'>
					<xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
				</xsl:if>
			</xsl:for-each>
			<xsl:value-of select="link_html"/>
		</xsl:element>
	</xsl:template>
	<!--
    this doesn't do anything with the description
	or render attributes...it simply decides whether
	to remove the entire subtree or just pass the
	content thru
	
	I need samples of the use description and render
	to know what really should be done with them
  -->
	<!--
<xsl:template match='local_markup'>
	<xsl:choose>
		<xsl:when test='@ignore="markup"'>
			<xsl:apply-templates/>
		</xsl:when>
	</xsl:choose>
</xsl:template>
-->
	<xsl:template match="@ignore">
		<xsl:choose>
			<xsl:when test='.="markup"'>
				<xsl:apply-templates select="../text()"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
     elements to ignore
  -->
	<xsl:template match="coded_entry"/>
	<xsl:template match="caption_cd"/>
	
	<!-- JIL 16.10.2001
	Local_markup for encoding dates in the body section of the document -->
	<xsl:template match='local_markup/local_attr[@name="dttm"]'>
		<xsl:call-template name="date">
			<xsl:with-param name="date" select="@value"/>
		</xsl:call-template>
	</xsl:template>
<!--	
     template(s) to output signature block
     Assumes there is only one signer at this time
  -->
	<xsl:template name="signature">
		<xsl:variable name="signers" select="/levelone/clinical_document_header/legal_authenticator/person"/>
		<xsl:if test="$signers">
			<div>
				<span class="caption">Allekirjoitus: </span>
				<xsl:for-each select="$signers">
					<xsl:call-template name="getName">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
					<xsl:text/>
					<xsl:call-template name="date">
						<xsl:with-param name="date" select="../participation_tmr/@V"/>
					</xsl:call-template>
				</xsl:for-each>
			</div>
		</xsl:if>
	</xsl:template>
	<!--
     general purpose (named) templates used in multiple places
  -->
	<!--
     assumes current node is a <person_name> node

     Does not handle nearly all of the complexity of the person datatype,
	 but is illustritive of what would be required to do so in the future
  -->
	<xsl:template name="getName">
	<!-- No test for Legal name -->
	<!--	<xsl:apply-templates select='person_name[person_name.type_cd/@V="L"]'/>-->
		<xsl:apply-templates select='person_name'/>
	</xsl:template>
	<xsl:template match="person_name">
		<xsl:choose>
			<xsl:when test='nm/GIV[@QUAL="RE"]/@V'>
				<xsl:value-of select='nm/GIV[@QUAL="RE"]/@V'/>
			</xsl:when>
			<xsl:when test='nm/GIV[@CLAS="N"]/@V'>
				<xsl:value-of select='nm/GIV[@CLAS="N"]/@V'/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="nm/GIV/@V"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text> </xsl:text>
		<xsl:choose>
			<xsl:when test='nm/FAM[@QUAL="RE"]/@V'>
				<xsl:value-of select='nm/FAM[@QUAL="RE"]/@V'/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="nm/FAM/@V"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text> </xsl:text>
		<xsl:choose>
			<xsl:when test='nm/SFX[@QUAL="RE"]/@V'>
				<xsl:text>, </xsl:text>
				<xsl:value-of select='nm/SFX[@QUAL="RE"]/@V'/>
			</xsl:when>
			<xsl:when test="nm/SFX/@V">
				<xsl:text>, </xsl:text>
				<xsl:value-of select="nm/SFX/@V"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Removed this date template 9.6.2002 T.Itala-->
	<!--
     outputs a date in Month Day, Year form	 
	 e.g., 19991207  ==> December 07, 1999
   
	<xsl:template name="date">
		<xsl:param name="date"/>
		<xsl:variable name="month" select="substring ($date, 6, 2)"/>
		<xsl:choose>
			<xsl:when test="$month=01">
				<xsl:text>January </xsl:text>
			</xsl:when>
			<xsl:when test="$month=02">
				<xsl:text>February </xsl:text>
			</xsl:when>
			<xsl:when test="$month=03">
				<xsl:text>March </xsl:text>
			</xsl:when>
			<xsl:when test="$month=04">
				<xsl:text>April </xsl:text>
			</xsl:when>
			<xsl:when test="$month=05">
				<xsl:text>May </xsl:text>
			</xsl:when>
			<xsl:when test="$month=06">
				<xsl:text>June </xsl:text>
			</xsl:when>
			<xsl:when test="$month=07">
				<xsl:text>July </xsl:text>
			</xsl:when>
			<xsl:when test="$month=08">
				<xsl:text>August </xsl:text>
			</xsl:when>
			<xsl:when test="$month=09">
				<xsl:text>September </xsl:text>
			</xsl:when>
			<xsl:when test="$month=10">
				<xsl:text>October </xsl:text>
			</xsl:when>
			<xsl:when test="$month=11">
				<xsl:text>November </xsl:text>
			</xsl:when>
			<xsl:when test="$month=12">
				<xsl:text>December </xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test='substring ($date, 9, 1)="0"'>
				<xsl:value-of select="substring ($date, 10, 1)"/>
				<xsl:text>, </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring ($date, 9, 2)"/>
				<xsl:text>, </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="substring ($date, 1, 4)"/>
	</xsl:template>
	-->
	<!-- Output of date in Finnish format "dd.mm.yyyy klo hh:mm:ss"
	vvvv 	1-4
	-		5
	mm		6-7
	-		8
	dd		9-10
	T		11
	hh		12-13
	:		14
	mm		15-16
	:		17
	ss		18
	-->
	<xsl:template name="date">
		<xsl:param name="date"/>	
		<xsl:choose>
		<xsl:when test="contains($date,'..')">				
			<xsl:call-template name="datesingle">
				<xsl:with-param name="pdatesingle" select="substring-before ($date,'..')"/>
			</xsl:call-template>
			<xsl:text> - </xsl:text>
			<xsl:call-template name="datesingle">
				<xsl:with-param name="pdatesingle" select="substring-after ($date,'..')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="datesingle">
				<xsl:with-param name="pdatesingle" select="$date"/>
			</xsl:call-template>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
		
	<xsl:template name="datesingle">
		<xsl:param name="pdatesingle"/>
		<!-- PP-->
		<xsl:if test='substring ($pdatesingle, 7, 2)!=""'>
			<xsl:value-of select="substring ($pdatesingle,7, 2)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- KK-->
		<xsl:if test='substring ($pdatesingle, 5, 2)!=""'>
			<xsl:value-of select="substring ($pdatesingle, 5, 2)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<xsl:value-of select="substring ($pdatesingle, 1, 4)"/>
		<xsl:text/>
		<xsl:if test='substring ($pdatesingle, 9, 2)!=""'>
			<xsl:text> klo </xsl:text>
			<xsl:value-of select="substring ($pdatesingle,9, 2)"/>
		</xsl:if>
		<xsl:if test='substring ($pdatesingle, 11, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,11, 2)"/>
		</xsl:if>
		<xsl:if test='substring ($pdatesingle, 13, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,13, 2)"/>
		</xsl:if>
	</xsl:template>
	<!--
     table lookups
  -->
	<!-- not used in Finland, removed 9.6.2002 TItala -->
	<!--   <xsl:template name="provider_type_cd">
		<xsl:param name="type_cd"/>
		<xsl:choose>
			<xsl:when test='$type_cd="CON"'>
				<xsl:text>Consultant</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="PRISURG"'>
				<xsl:text>Primary surgeon</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="FASST"'>
				<xsl:text>First assistant</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="SASST"'>
				<xsl:text>Second assistant</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="SNRS"'>
				<xsl:text>Scrub nurse</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="TASST"'>
				<xsl:text>Third assistant</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="NASST"'>
				<xsl:text>Nurse assistant</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="ANEST"'>
				<xsl:text>Anesthetist</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="ANRS"'>
				<xsl:text>Anesthesia nurse</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="MDWF"'>
				<xsl:text>Midwife</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="ATTPHYS"'>
				<xsl:text>Attending physician</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="ADMPHYS"'>
				<xsl:text>Admitting physician</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="DISPHYS"'>
				<xsl:text>Discharging physician</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="RNDPHYS"'>
				<xsl:text>Rounding physician</xsl:text>
			</xsl:when>
			<xsl:when test='$type_cd="PCP"'>
				<xsl:text>Primary care provider</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$type_cd"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>-->
	
	<xsl:template name="administrative_gender_cd">
		<xsl:param name="gender_cd"/>
		<xsl:choose>
			<xsl:when test='$gender_cd="M"'>
				<xsl:text>Male</xsl:text>
			</xsl:when>
			<xsl:when test='$gender_cd="F"'>
				<xsl:text>Female</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$gender_cd"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
