<!--
	<model @_container>
	   MARKUP
	   <element @_id @_defId @name @minOccurs @maxOccurs/>
	   <attribute @_id @use @default @fixed/>
	   GROUPING
	   <sequence|choice @_id @_defId @minOccurs @maxOccurs/>
	   <list|union/>
	   <mixed/>
	   RESTRICTION
	   <type/>
	   <enumeration|pattern|minInclusive|... @value/>
	   MEANING
	   <documentation @source @_name @_value @_option/>
	</model>
-->

<xsl:stylesheet
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xt="http://www.jclark.com/xt"
   version="1.0">

<xsl:template match="/">
<!-- parameter as document element attributes -->
<xsl:variable name="_documentId" select="schema/@_documentId"/>
<xsl:variable name="_selectedId" select="schema/@_selectedId"/>
<xsl:variable name="_parentGroup" select="schema/@_parentGroup"/>
<!-- create dereferenced schema -->
<xsl:element name="model">
<xsl:for-each select="//*[@_id = $_selectedId]"> <!-- set context to selected element -->
<xsl:attribute name="_container"><xsl:value-of select="name(.)"/></xsl:attribute>
<xsl:variable name="typeRef" select="@type"/>
<xsl:call-template name="meaningOf"><xsl:with-param name="_name" select="@name"/></xsl:call-template>
<xsl:choose><xsl:when test="count(parent::*) > 0">
<xsl:variable name="type" select="*|/schema/simpleType[@name=$typeRef]|/schema/complexType[@name=$typeRef]"/>
<xsl:apply-templates select="$type">
<xsl:with-param name="parentGroup">
<xsl:if test="contains('choice|sequence', name(.))"><xsl:value-of select="$_parentGroup"/></xsl:if>
</xsl:with-param>
</xsl:apply-templates>
<xsl:if test="count($type) = 0">
<xsl:element name="type">any</xsl:element>
</xsl:if>
</xsl:when><xsl:otherwise>
<xsl:apply-templates select="element[@_id = $_documentId]"/> <!-- document element -->
</xsl:otherwise></xsl:choose>
</xsl:for-each>
</xsl:element>
</xsl:template>

<xsl:template name="meaningOf">
<xsl:param name="_name"/>
<xsl:param name="_value"/>
<xsl:param name="_option"/>
<xsl:for-each select="annotation/documentation">
<xsl:element name="documentation">
<xsl:if test="$_name != ''"><xsl:attribute name="_name"><xsl:value-of select="$_name"/></xsl:attribute></xsl:if>
<xsl:if test="$_value != ''"><xsl:attribute name="_value"><xsl:value-of select="$_value"/></xsl:attribute></xsl:if>
<xsl:attribute name="_option"><xsl:value-of select="$_option"/></xsl:attribute>
<xsl:copy-of select="@*"/>
<xsl:copy-of select="node()"/>
</xsl:element>
</xsl:for-each>
</xsl:template>

<xsl:template match="*"/> <!-- more specific template overrules -->

<!--
*****************************
*          element          *
*****************************
-->
<xsl:template match="element">
<xsl:choose><xsl:when test="count(@ref) > 0">			<!-- element reference -->
<xsl:call-template name="meaningOf"><xsl:with-param name="_name" select="@ref"/><xsl:with-param name="_option" select="@minOccurs"/></xsl:call-template>
<xsl:variable name="ref" select="@ref"/>
<xsl:apply-templates select="/schema/element[@name=$ref]">
<xsl:with-param name="_id" select="@_id"/>
<xsl:with-param name="minOccurs" select="@minOccurs"/>
<xsl:with-param name="maxOccurs" select="@maxOccurs"/>
</xsl:apply-templates>
</xsl:when><xsl:otherwise>					<!-- element definition -->
<xsl:param name="_id"/>
<xsl:param name="minOccurs"/>
<xsl:param name="maxOccurs"/>
<xsl:variable name="_minOccurs">
<xsl:choose><xsl:when test="$minOccurs != ''"><xsl:value-of select="$minOccurs"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@minOccurs"/>
</xsl:otherwise></xsl:choose>
</xsl:variable>
<xsl:call-template name="meaningOf"><xsl:with-param name="_name" select="@name"/><xsl:with-param name="_option" select="$_minOccurs"/></xsl:call-template>
<xsl:element name="element">
<xsl:choose><xsl:when test="$_id != ''">
<xsl:attribute name="_id"><xsl:value-of select="$_id"/></xsl:attribute>
<xsl:attribute name="_defId"><xsl:value-of select="@_id"/></xsl:attribute>
</xsl:when><xsl:otherwise>
<xsl:copy-of select="@_id"/>
</xsl:otherwise></xsl:choose>
<xsl:copy-of select="@name"/>
<xsl:if test="$_minOccurs != ''"><xsl:attribute name="minOccurs"><xsl:value-of select="$_minOccurs"/></xsl:attribute></xsl:if>
<xsl:if test="$maxOccurs != '' or @maxOccurs != ''">
<xsl:attribute name="maxOccurs">
<xsl:choose><xsl:when test="$maxOccurs != ''"><xsl:value-of select="$maxOccurs"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@maxOccurs"/>
</xsl:otherwise></xsl:choose>
</xsl:attribute>
</xsl:if>
</xsl:element>
</xsl:otherwise></xsl:choose>
</xsl:template>

<!--
*******************************
*          attribute          *
*******************************
-->
<xsl:template match="attribute">
<xsl:choose><xsl:when test="count(@ref) > 0">			<!-- attribute reference -->
<xsl:call-template name="meaningOf"><xsl:with-param name="_name" select="@ref"/><xsl:with-param name="_option" select="@use"/></xsl:call-template>
<xsl:variable name="ref" select="@ref"/>
<xsl:apply-templates select="/schema/attribute[@name=$ref]">
<xsl:with-param name="use" select="@use"/>
<xsl:with-param name="default" select="@default"/>
<xsl:with-param name="fixed" select="@fixed"/>
</xsl:apply-templates>
</xsl:when><xsl:otherwise>					<!-- attribute definition -->
<xsl:param name="use"/>
<xsl:param name="default"/>
<xsl:param name="fixed"/>
<xsl:variable name="_use">
<xsl:choose><xsl:when test="$use != ''"><xsl:value-of select="$use"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@use"/>
</xsl:otherwise></xsl:choose>
</xsl:variable>
<xsl:call-template name="meaningOf"><xsl:with-param name="_name" select="@name"/><xsl:with-param name="_option" select="$_use"/></xsl:call-template>
<xsl:element name="attribute">
<xsl:copy-of select="@_id|@name"/>
<xsl:if test="$_use != ''"><xsl:attribute name="use"><xsl:value-of select="$_use"/></xsl:attribute></xsl:if>
<xsl:if test="$default != '' or @default != ''">
<xsl:attribute name="default">
<xsl:choose><xsl:when test="$default != ''"><xsl:value-of select="$default"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@default"/>
</xsl:otherwise></xsl:choose>
</xsl:attribute>
</xsl:if>
<xsl:if test="$fixed != '' or @fixed != ''">
<xsl:attribute name="fixed">
<xsl:choose><xsl:when test="$fixed != ''"><xsl:value-of select="$fixed"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@fixed"/>
</xsl:otherwise></xsl:choose>
</xsl:attribute>
</xsl:if>
</xsl:element>
</xsl:otherwise></xsl:choose>
</xsl:template>

<!--
************************************
*          attributeGroup          *
************************************
-->
<xsl:template match="attributeGroup">
<xsl:call-template name="meaningOf"/>
<xsl:choose><xsl:when test="count(@ref) > 0">				<!-- attributeGroup reference -->
<xsl:variable name="ref" select="@ref"/>
<xsl:apply-templates select="/schema/attributeGroup[@name=$ref]"/>
</xsl:when><xsl:otherwise>						<!-- attribute definition -->
<xsl:apply-templates select="attribute|attributeGroup"/>
</xsl:otherwise></xsl:choose>
</xsl:template>

<!--
*********************************
*          restriction          *
*********************************
-->
<xsl:template match="restriction">					<!-- enumeration, pattern, minInclusive etc. -->
<xsl:call-template name="meaningOf"/>
<xsl:variable name="base" select="@base"/>
<!-- enumeration and pattern are more restrictive than base type -->
<xsl:if test="count(*[name(.) != 'enumeration' and name(.) != 'pattern']) > 0">
<xsl:apply-templates select="/schema/simpleType[@name=$base]"/>
</xsl:if>
<xsl:for-each select="*">
<xsl:call-template name="meaningOf"><xsl:with-param name="_value" select="@value"/></xsl:call-template>
<xsl:element name="{name(.)}">
<xsl:copy-of select="@*"/>
</xsl:element>
</xsl:for-each>
</xsl:template>

<!--
***************************
*          union          *
***************************
-->
<xsl:template match="union">
<xsl:call-template name="meaningOf"/>
<xsl:variable name="memberTypes" select="@memberTypes"/>
<xsl:element name="union">
<xsl:choose><xsl:when test="count(simpleType) > 0">
<xsl:apply-templates select="simpleType"/>
</xsl:when><xsl:otherwise>
<xsl:for-each select="/schema/simpleType"> <!-- /schema/simpleType[contains($memberTypes, @name)] does not work -->
<xsl:if test="contains($memberTypes, @name)">
<xsl:apply-templates select="."/>
</xsl:if>
</xsl:for-each>
</xsl:otherwise></xsl:choose>
</xsl:element>
</xsl:template>

<!--
**************************
*          list          *
**************************
-->
<xsl:template match="list">
<xsl:call-template name="meaningOf"/>
<xsl:variable name="itemType" select="normalize-space(@itemType)"/>
<xsl:element name="list">
<xsl:apply-templates select="simpleType|/schema/simpleType[@name=$itemType]"/>
</xsl:element>
</xsl:template>

<!--
********************************
*          simpleType          *
********************************
-->
<xsl:template match="simpleType">
<xsl:call-template name="meaningOf"/>
<xsl:variable name="content" select="list|union|restriction"/>
<xsl:choose><xsl:when test="count($content) > 0">
<xsl:apply-templates select="$content"/>
</xsl:when><xsl:otherwise> <!-- built in simple type -->
<xsl:element name="type"><xsl:value-of select="@name"/></xsl:element>
</xsl:otherwise></xsl:choose>
</xsl:template>

<!--
*******************************
*          extension          *
*******************************
-->
<xsl:template match="extension">
<xsl:call-template name="meaningOf"/>
<xsl:param name="parentGroup"/>
<xsl:variable name="base" select="@base"/>
<xsl:apply-templates select="/schema/simpleType[@name=$base]"/>
<xsl:apply-templates select="/schema/complexType[@name=$base]|group|all|choice|sequence">
<xsl:with-param name="parentGroup" select="$parentGroup"/>
</xsl:apply-templates>
<xsl:apply-templates select="attribute|attributeGroup"/>
</xsl:template>

<!--
************************************
*          complexContent          *
************************************
-->
<xsl:template match="complexContent">
<xsl:call-template name="meaningOf"/>
<xsl:param name="parentGroup"/>
<xsl:if test="$parentGroup = '' and @mixed = 'true'">					<!-- non-recursive call -->
<xsl:element name="mixed"/>
</xsl:if>
<xsl:if test="count(extension) > 0">
<xsl:choose><xsl:when test="not(contains($parentGroup, 'sequence'))">			<!-- extension implies sequence -->
<xsl:element name="sequence">
<xsl:apply-templates select="extension">
<xsl:with-param name="parentGroup">sequence</xsl:with-param>
</xsl:apply-templates>
</xsl:element>
</xsl:when><xsl:otherwise>
<xsl:apply-templates select="extension">
<xsl:with-param name="parentGroup" select="$parentGroup"/>
</xsl:apply-templates>
</xsl:otherwise></xsl:choose>
</xsl:if>
</xsl:template>

<!--
***********************************
*          simpleContent          *
***********************************
-->
<xsl:template match="simpleContent">
<xsl:call-template name="meaningOf"/>
<xsl:apply-templates select="restriction|extension"/>
</xsl:template>

<!--
*********************************
*          complexType          *
*********************************
-->
<xsl:template match="complexType">
<xsl:call-template name="meaningOf"/>
<xsl:param name="parentGroup"/>
<xsl:if test="$parentGroup = '' and @mixed = 'true'">					<!-- non-recursive call -->
<xsl:element name="mixed"/>
</xsl:if>
<xsl:apply-templates select="simpleContent"/>
<xsl:apply-templates select="complexContent|group|all|choice|sequence">
<xsl:with-param name="parentGroup" select="$parentGroup"/>				<!-- pass thru -->
</xsl:apply-templates>
<xsl:apply-templates select="attribute|attributeGroup"/>
</xsl:template>

<!--
***************************
*          group          *
***************************
-->
<xsl:template match="group">
<xsl:call-template name="meaningOf"/>
<xsl:param name="_id"/>
<xsl:param name="minOccurs"/>
<xsl:param name="maxOccurs"/>
<xsl:param name="parentGroup"/>
<xsl:choose><xsl:when test="count(@ref) > 0">			<!-- group reference -->
<xsl:variable name="ref" select="@ref"/>
<xsl:apply-templates select="/schema/group[@name=$ref]">
<xsl:with-param name="_id" select="@_id"/>
<xsl:with-param name="minOccurs" select="@minOccurs"/>
<xsl:with-param name="maxOccurs" select="@maxOccurs"/>
<xsl:with-param name="parentGroup" select="$parentGroup"/>
</xsl:apply-templates>
</xsl:when><xsl:otherwise>					<!-- group definition -->
<xsl:apply-templates select="all|choice|sequence">
<xsl:with-param name="_id" select="$_id"/>
<xsl:with-param name="minOccurs" select="$minOccurs"/>
<xsl:with-param name="maxOccurs" select="$maxOccurs"/>
<xsl:with-param name="parentGroup" select="$parentGroup"/>
</xsl:apply-templates>
</xsl:otherwise></xsl:choose>
</xsl:template>

<!--
****************************
*          choice          *
****************************
-->
<xsl:template match="choice">
<xsl:call-template name="meaningOf"/>
<xsl:param name="_id"/>
<xsl:param name="minOccurs"/>
<xsl:param name="maxOccurs"/>
<xsl:param name="parentGroup"/>
<xsl:variable name="_minOccurs">
<xsl:choose><xsl:when test="$minOccurs != ''"><xsl:value-of select="$minOccurs"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@minOccurs"/>
</xsl:otherwise></xsl:choose>
</xsl:variable>
<xsl:variable name="_maxOccurs">
<xsl:choose><xsl:when test="$maxOccurs != ''"><xsl:value-of select="$maxOccurs"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@maxOccurs"/>
</xsl:otherwise></xsl:choose>
</xsl:variable>
<!-- reducible -->
<xsl:choose><xsl:when test="contains('1', $_minOccurs) and contains('1', $_maxOccurs) and count(*) = 1">
<xsl:apply-templates select="element|group|choice|sequence|any">
<xsl:with-param name="parentGroup" select="$parentGroup"/> <!-- ignore this choice -->
</xsl:apply-templates>
</xsl:when><xsl:when test="$parentGroup = 'unlimitedChoice' and $_minOccurs = '0' and $_maxOccurs='unbounded'">
<xsl:apply-templates select="element|group|choice|sequence|any">
<xsl:with-param name="parentGroup" select="$parentGroup"/> <!-- ignore this choice -->
</xsl:apply-templates>
<!-- irreducible -->
</xsl:when><xsl:otherwise>
<xsl:element name="choice">
<xsl:choose><xsl:when test="$_id != ''">
<xsl:attribute name="_id"><xsl:value-of select="$_id"/></xsl:attribute>
<xsl:attribute name="_defId"><xsl:value-of select="@_id"/></xsl:attribute>
</xsl:when><xsl:otherwise>
<xsl:copy-of select="@_id"/>
</xsl:otherwise></xsl:choose>
<xsl:if test="$_minOccurs != ''"><xsl:attribute name="minOccurs"><xsl:value-of select="$_minOccurs"/></xsl:attribute></xsl:if>
<xsl:if test="$_maxOccurs != ''"><xsl:attribute name="maxOccurs"><xsl:value-of select="$_maxOccurs"/></xsl:attribute></xsl:if>
<xsl:apply-templates select="element|group|choice|sequence|any">
<xsl:with-param name="parentGroup">
<xsl:if test="$_minOccurs = '0' and $_maxOccurs='unbounded'">unlimitedChoice</xsl:if>
</xsl:with-param>
</xsl:apply-templates>
</xsl:element>
</xsl:otherwise></xsl:choose>
</xsl:template>

<!--
******************************
*          sequence          *
******************************
-->
<xsl:template match="sequence">
<xsl:call-template name="meaningOf"/>
<xsl:param name="_id"/>
<xsl:param name="minOccurs"/>
<xsl:param name="maxOccurs"/>
<xsl:param name="parentGroup"/>
<xsl:variable name="_minOccurs">
<xsl:choose><xsl:when test="$minOccurs != ''"><xsl:value-of select="$minOccurs"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@minOccurs"/>
</xsl:otherwise></xsl:choose>
</xsl:variable>
<xsl:variable name="_maxOccurs">
<xsl:choose><xsl:when test="$maxOccurs != ''"><xsl:value-of select="$maxOccurs"/>
</xsl:when><xsl:otherwise><xsl:value-of select="@maxOccurs"/>
</xsl:otherwise></xsl:choose>
</xsl:variable>
<!-- reducible -->
<xsl:choose><xsl:when test="contains('1', $_minOccurs) and contains('1', $_maxOccurs) and count(*) = 1">
<xsl:apply-templates select="element|group|choice|sequence|any">
<xsl:with-param name="parentGroup" select="$parentGroup"/> <!-- ignore this sequence -->
</xsl:apply-templates>
</xsl:when><xsl:when test="contains('1', $_minOccurs) and contains('1', $_maxOccurs) and $parentGroup = 'sequence'">
<xsl:apply-templates select="element|group|choice|sequence|any">
<xsl:with-param name="parentGroup" select="$parentGroup"/> <!-- ignore this sequence -->
</xsl:apply-templates>
<!-- irreducible -->
</xsl:when><xsl:otherwise>
<xsl:element name="sequence">
<xsl:choose><xsl:when test="$_id != ''">
<xsl:attribute name="_id"><xsl:value-of select="$_id"/></xsl:attribute>
<xsl:attribute name="_defId"><xsl:value-of select="@_id"/></xsl:attribute>
</xsl:when><xsl:otherwise>
<xsl:copy-of select="@_id"/>
</xsl:otherwise></xsl:choose>
<xsl:if test="$_minOccurs != ''"><xsl:attribute name="minOccurs"><xsl:value-of select="$_minOccurs"/></xsl:attribute></xsl:if>
<xsl:if test="$_maxOccurs != ''"><xsl:attribute name="maxOccurs"><xsl:value-of select="$_maxOccurs"/></xsl:attribute></xsl:if>
<xsl:apply-templates select="element|group|choice|sequence|any">
<xsl:with-param name="parentGroup">sequence</xsl:with-param>
</xsl:apply-templates>
</xsl:element>
</xsl:otherwise></xsl:choose>
</xsl:template>

</xsl:stylesheet>