/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.OutputMethodHandlerImpl;
import com.jclark.xsl.sax.ServletDestination;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XSLServlet
extends HttpServlet {
    private XSLProcessor cached;

    static Parser createParser() throws ServletException {
        String string = System.getProperty("com.jclark.xsl.sax.parser");
        if (string == null) {
            string = System.getProperty("org.xml.sax.parser");
        }
        if (string == null) {
            string = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException((Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new ServletException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServletException((Throwable)illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new ServletException(string + " is not a SAX driver");
        }
    }

    public static InputSource fileInputSource(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            return new InputSource(new URL("file", "", string).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public void init() throws ServletException {
        String string = this.getInitParameter("stylesheet");
        if (string == null) {
            throw new ServletException("missing stylesheet parameter");
        }
        this.cached = new XSLProcessorImpl();
        this.cached.setParser(XSLServlet.createParser());
        try {
            this.cached.loadStylesheet(new InputSource(this.getServletContext().getResource(string).toString()));
            return;
        }
        catch (SAXException sAXException) {
            throw new ServletException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        File file = new File(httpServletRequest.getPathTranslated());
        if (!file.isFile() && !(file = new File(httpServletRequest.getPathTranslated() + ".xml")).isFile()) {
            httpServletResponse.sendError(404, "File not found: " + httpServletRequest.getPathTranslated());
            return;
        }
        XSLProcessor xSLProcessor = (XSLProcessor)this.cached.clone();
        xSLProcessor.setParser(XSLServlet.createParser());
        Object object = httpServletRequest.getParameterNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            xSLProcessor.setParameter(string, httpServletRequest.getParameter(string));
        }
        object = new OutputMethodHandlerImpl(xSLProcessor);
        xSLProcessor.setOutputMethodHandler((OutputMethodHandler)object);
        ((OutputMethodHandlerImpl)object).setDestination(new ServletDestination((ServletResponse)httpServletResponse));
        try {
            xSLProcessor.parse(XSLServlet.fileInputSource(file));
            return;
        }
        catch (SAXException sAXException) {
            throw new ServletException((Throwable)sAXException);
        }
    }
}

