<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- CDA R2 Ballot 3 Tyylitiedosto, HL7 Finland/TI 23.9.2004 -->
<!-- Muutoshistoria -->
<!-- 2005.01.30: Muutettu elementtien nimet yhteensopiviksi Jan2005 CDA scheman kanssa-->
<!-- 2004.09.28: Listty xsl:output lause, jossa sanotaan merkkivalikoimaksi ISO-8859-1. -->
<!-- Muista pivitt tyylitiedoston versio html-head tagin jlkeen --> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
<!-- CDA document -->
<xsl:template match="/">
<xsl:apply-templates select="n1:ClinicalDocument"/>
</xsl:template>

<xsl:template match="n1:ClinicalDocument">
        <html>
            <head />
            <xsl:comment>				
              HL7 Finland  R2 Tyylitiedosto: Tyyli_R2_B4_01.xslt
            </xsl:comment>
            <body>            
				<xsl:apply-templates select="n1:title"/>
				<xsl:apply-templates select="n1:component/n1:structuredBody"/> 
            </body>
        </html>
</xsl:template>
    
<!-- Document title -->    
<xsl:template match="n1:ClinicalDocument/n1:title">
<h3>
<span style="font-weight:bold; color:green;">	
	<xsl:value-of select="."></xsl:value-of>
</span>
</h3>
<br />
</xsl:template>

<!-- structuredBody -->
<xsl:template match="n1:component/n1:structuredBody">
		<xsl:apply-templates select="n1:component/n1:section"/>
</xsl:template>

<!-- Component/Section -->    
<xsl:template match="n1:component/n1:section">
	<xsl:apply-templates select="n1:title"/>
		<ul>
			<xsl:apply-templates select="n1:text"/>
			
        <xsl:apply-templates select="n1:component/n1:section"/>
     
		</ul>
</xsl:template>



<!--   Title  -->
<xsl:template match="n1:title">
	<span style="font-weight:bold; color:green;">	
	<xsl:value-of select="."></xsl:value-of>
	</span>
</xsl:template>

<!--   Text   -->
<xsl:template match="n1:text">	
	<xsl:apply-templates />	
</xsl:template>

<!--   paragraph  -->
<xsl:template match="n1:paragraph">
	<xsl:apply-templates/>
	<br/>
</xsl:template>

<!--   content  -->
<xsl:template match="n1:content">
	<xsl:apply-templates/>
</xsl:template>

<!--   list  -->
<xsl:template match="n1:list">
<!--   listan otsikko  -->
    <xsl:if test="n1:caption">
        <span style="font-weight:bold; color:green;">
        <xsl:apply-templates select="n1:caption"/>
        </span>
		</xsl:if>
<!-- Jokainen listan alkio -->
			<xsl:for-each select="n1:item">
				<li>
					<!-- Lista-alkion elementti-->
          <xsl:apply-templates />
				</li>
			</xsl:for-each>
	</xsl:template>
	
	<!--   caption  -->
<xsl:template match="n1:caption">  
	<xsl:apply-templates/>
	<xsl:text>: </xsl:text>
</xsl:template>
	
	<!--      Tables
	 Koko alipuu kopioidaan sellaisenaan.
	 CAPTION elementin lapset ksitelln mahdollisilla muilla templateilla
  -->
	<xsl:template match="n1:table|n1:table/n1:caption|n1:thead|n1:tfoot|n1:tbody|n1:colgroup|n1:col|n1:tr|n1:th|n1:td">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="n1:table/n1:caption">
		<span style="font-weight:bold; ">	
			<xsl:apply-templates/>
		</span>	
	</xsl:template>
</xsl:stylesheet>
