<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- CDA R2 Ballot 3 Tyylitiedosto, HL7 Finland/TI 23.9.2004 -->
<!-- Muutoshistoria -->
<!-- 2004.12.12: Listty Sovittujen Header-elementtien muotoilu katseltaviksi. -->
<!-- 2004.12.12: Listty content-elementin attribuutin revised-ksittely. Eli lisykset ja poistot merkitn.-->
<!-- 2004.09.28: Listty xsl:output lause, jossa sanotaan merkkivalikoimaksi ISO-8859-1. -->
<!-- Muista pivitt tyylitiedoston versio html-head tagin jlkeen -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:hl7fi="urn:hl7finland" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
	<!-- CDA document -->
	<xsl:template match="/">
		<xsl:apply-templates select="n1:ClinicalDocument"/>
	</xsl:template>
	<xsl:template match="n1:ClinicalDocument">
		<html>
			<head/>
			<style>
				<xsl:comment>				
					 .class-normal {  font-style: normal; font-weight: normal; }
					 .class-bold {  font-style: normal; font-weight: bold; }
					 .class-underline { font-style: normal; font-weight: normal; text-decoration: underline; }
					 .class-italics { font-style: italic; font-weight: normal; }
					 .class-emphasis {  font-style: normal; font-weight: normal; background-color:yellow; }
					 .class-delete {  font-style: normal; font-weight: normal; text-decoration:line-through; }
					 .class-insert {  font-style: normal; font-weight: normal; text-decoration:underline; }
					 .class-caption {  font-style: normal; font-weight: bold;  }
	          	</xsl:comment>
			</style>
			<xsl:comment>				
              HL7 Finland  R2 Tyylitiedosto: Tyyli_R2_B3_03.xslt, 9.1.2005/TI
            </xsl:comment>
			<body>
				<xsl:apply-templates select="n1:code"/>
				<xsl:apply-templates select="n1:title"/>
				<xsl:apply-templates select="n1:id"/>
				<xsl:apply-templates select="n1:setId"/>
				<xsl:apply-templates select="n1:versionNumber"/>
				<xsl:apply-templates select="n1:effectiveTime"/>
				<xsl:apply-templates select="n1:custodian"/>
				<xsl:apply-templates select="n1:author"/>
				<xsl:apply-templates select="n1:componentOf"/>
				<xsl:apply-templates select="hl7fi:localHeader"/>
				<xsl:apply-templates select="n1:recordTarget"/>
				<br/>
				<xsl:apply-templates select="n1:component/n1:structuredBody"/>
			</body>
		</html>
	</xsl:template>
	<!-- Document title -->
	<xsl:template match="n1:ClinicalDocument/n1:code">
		<h3>
			<xsl:text>Kertomuksen virallinen tuloste (Tyyli_R2_Jan2005_03_ae 9.1.2005)</xsl:text>
		</h3>
	</xsl:template>
	<!-- Asiakirjan title -->
	<xsl:template match="n1:ClinicalDocument/n1:title">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Asiakirjan otsake: </xsl:text>
			</span>
			<xsl:value-of select="."/>
			<br/>
		</em>
	</xsl:template>
	<!-- Asiakirjan OID-tunnus -->
	<xsl:template match="n1:id">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Asiakirjan OID-tunnus: </xsl:text>
			</span>
			<xsl:value-of select="@root"/>
			<xsl:choose>
				<xsl:when test="@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</em>
	</xsl:template>
	<!-- Asiakirjan OID-tunnus -->
	<xsl:template match="n1:setId">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Alkuperisen asiakirjan OID-tunnus: </xsl:text>
			</span>
			<xsl:value-of select="@root"/>
			<xsl:choose>
				<xsl:when test="@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</em>
	</xsl:template>
	<!-- Asiakirjan versio -->
	<xsl:template match="n1:versionNumber">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Asiakirjan versio: </xsl:text>
			</span>
			<xsl:value-of select="@value"/>
			<br/>
		</em>
	</xsl:template>
	<!-- effectiveTime -->
	<xsl:template match="n1:effectiveTime">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Asiakirjan luontipiv: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="@value"/>
			</xsl:call-template>
			<br/>
		</em>
	</xsl:template>
	<!-- custodian -->
	<xsl:template match="n1:custodian">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Rekisterinpitj: </xsl:text>
			</span>
			<xsl:value-of select="n1:assignedCustodian/n1:representedCustodianOrganization/n1:name"/>
			<br/>
		</em>
	</xsl:template>
	<!-- xxxxxxx -->
	<xsl:template match="n1:componentOf">
		<br/>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Kokonaishoitoaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:encompassingEncounter/n1:effectiveTime/n1:low/@value"/>
			</xsl:call-template>
			<xsl:text> - </xsl:text>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:encompassingEncounter/n1:effectiveTime/n1:high/@value"/>
			</xsl:call-template>
			<br/>
		</em>
		<xsl:for-each select="n1:encompassingEncounter/n1:encounterParticipant">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>Osaston hoitoaika: </xsl:text>
				</span>
				<xsl:call-template name="date">
					<xsl:with-param name="date" select="n1:time/n1:low/@value"/>
				</xsl:call-template>
				<xsl:text> - </xsl:text>
				<xsl:call-template name="date">
					<xsl:with-param name="date" select="n1:time/n1:high/@value"/>
				</xsl:call-template>
				<span style="font-weight:bold; color:green;">
					<xsl:text> toimipaikka: </xsl:text>
				</span>
				<xsl:value-of select="n1:assignedEntity/n1:representedOrganization/n1:name"/>
				<br/>
			</em>
		</xsl:for-each>
	</xsl:template>
	<!-- author -->
	<xsl:template match="n1:author">
		<br/>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Hoidon alkuaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:time/@value"/>
			</xsl:call-template>
			<br/>
		</em>
		<xsl:choose>
			<xsl:when test="n1:assignedAuthor/n1:assignedPerson/n1:name">
				<em class="class-caption">
					<span style="font-weight:bold; color:green;">
						<xsl:text>Asiakirjan laatija: </xsl:text>
					</span>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:suffix"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family"/>
					<br/>
				</em>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="n1:assignedAuthor/n1:representedOrganization/n1:name">
				<em class="class-caption">
					<span style="font-weight:bold; color:green;">
						<xsl:text>Asiakirjan laatijan toimipaikka: </xsl:text>
					</span>
					<xsl:value-of select="n1:assignedAuthor/n1:representedOrganization/n1:name"/>
					<br/>
				</em>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- recordTarget -->
	<xsl:template match="n1:recordTarget">
		<em class="class-caption">
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>Potilaan henkiltunnus: </xsl:text>
			</span>
			<xsl:value-of select="n1:patient/n1:id/@extension"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>Potilaan nimi: </xsl:text>
			</span>
			<xsl:value-of select="n1:patient/n1:patientPatient/n1:name/n1:family"/>
			<xsl:text>, </xsl:text>
			<xsl:value-of select="n1:patient/n1:patientPatient/n1:name/n1:given"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>Potilaan sukupuoli: </xsl:text>
			</span>
			<xsl:value-of select="n1:patient/n1:patientPatient/n1:administrativeGenderCode/@code"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>Potilaan syntymaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:patient/n1:patientPatient/n1:birthTime/@value"/>
			</xsl:call-template>
			<br/>
		</em>
	</xsl:template>
	<!-- Local Header -->
	<xsl:template match="hl7fi:localHeader">
		<br/>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>hl7fi:versio: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:versio"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>hl7fi:rekisteri: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:rekisteri/@displayName"/>
			<br/>
		</em>
		<xsl:for-each select="hl7fi:linkDocumentId">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>hl7fi:linkDocumentId: </xsl:text>
				</span>
				<xsl:value-of select="@root"/>
				<xsl:choose>
					<xsl:when test="@extension">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@extension"/>
					</xsl:when>
				</xsl:choose>
				<br/>
			</em>
		</xsl:for-each>
		<xsl:for-each select="hl7fi:palveluketjutunnus">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>hl7fi:palveluketjutunnus: </xsl:text>
				</span>
				<xsl:value-of select="@root"/>
				<xsl:choose>
					<xsl:when test="@extension">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@extension"/>
					</xsl:when>
				</xsl:choose>
				<br/>
			</em>
		</xsl:for-each>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>hl7fi:lhettv jrjestelm: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:lahettaja"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>hl7fi:silytysaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="hl7fi:sailytysaika"/>
			</xsl:call-template>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>hl7fi:lomakkeet:</xsl:text>
			</span>
		</em>
		<xsl:for-each select="hl7fi:lomake/hl7fi:lomakeCode/@displayName">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>...</xsl:text>
				</span>
				<xsl:value-of select="."/>
			</em>
		</xsl:for-each>
		<br/>
		<xsl:for-each select="hl7fi:lisaus">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>hl7fi:lisysaika: </xsl:text>
				</span>
				<xsl:call-template name="date">
					<xsl:with-param name="date" select="hl7fi:lisausAika"/>
				</xsl:call-template>
				<span style="font-weight:bold; color:green;">
					<xsl:text> objekti: </xsl:text>
				</span>
				<xsl:value-of select="hl7fi:lisausObjekti/@root"/>
				<br/>
			</em>
		</xsl:for-each>
		<xsl:for-each select="n1:Signature">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>hl7fi:shkinen allekirjoitus: </xsl:text>
				</span>
				<xsl:value-of select="n1:SignedInfo/n1:Reference/@URI"/>
				<br/>
			</em>
		</xsl:for-each>
	</xsl:template>
	<!-- StructuredBody -->
	<xsl:template match="n1:component/n1:structuredBody">
		<xsl:apply-templates select="n1:component/n1:section"/>
	</xsl:template>
	<!-- Component/Section -->
	<xsl:template match="n1:component/n1:section">
		<xsl:apply-templates select="n1:title"/>
		<ul>
			<xsl:apply-templates select="n1:text"/>
			<xsl:apply-templates select="n1:component/n1:section"/>
		</ul>
	</xsl:template>
	<!--   Title  -->
	<xsl:template match="n1:title">
		<span style="font-weight:bold; color:green;">
			<xsl:value-of select="."/>
		</span>
	</xsl:template>
	<!--   Text   -->
	<xsl:template match="n1:text">
		<xsl:apply-templates/>
	</xsl:template>
	<!--   paragraph  -->
	<xsl:template match="n1:paragraph">
		<xsl:apply-templates/>
		<br/>
	</xsl:template>
	<!--   content  -->
	<xsl:template match="n1:content">
		<xsl:choose>
			<xsl:when test='@revised="delete"'>
				<em class="class-delete">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="insert"'>
				<em class="class-insert">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Bold"'>
				<em class="class-bold">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Underline"'>
				<em class="class-underline">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Italics"'>
				<em class="class-italics">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Emphasis"'>
				<em class="class-italics">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--   list  -->
	<xsl:template match="n1:list">
		<!--   listan otsikko  -->
		<xsl:if test="n1:caption">
			<span style="font-weight:bold; ">
				<xsl:apply-templates select="n1:caption"/>
			</span>
		</xsl:if>
		<!-- Jokainen listan alkio -->
		<xsl:for-each select="n1:item">
			<li>
				<!-- Lista-alkion elementti-->
				<xsl:apply-templates/>
			</li>
		</xsl:for-each>
	</xsl:template>
	<!--   caption  -->
	<xsl:template match="n1:caption">
		<xsl:apply-templates/>
		<xsl:text>: </xsl:text>
	</xsl:template>
	<!--      Tables
	 Koko alipuu kopioidaan sellaisenaan.
	 CAPTION elementin lapset ksitelln mahdollisilla muilla templateilla
  -->
	<xsl:template match="n1:table|n1:table/n1:caption|n1:thead|n1:tfoot|n1:tbody|n1:colgroup|n1:col|n1:tr|n1:th|n1:td">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/n1:caption">
		<span style="font-weight:bold; ">
			<xsl:apply-templates/>
		</span>
	</xsl:template>
	<!-- Nimen tulostaminen -->
	<xsl:template name="getName">
		<xsl:apply-templates select="n1:name"/>
	</xsl:template>
	<!-- Pivmrn ja kellonajan tai -vlien muotoilu ulkoasuun pp.kk.vvvv klo hh:mm:ss -->
	<xsl:template name="date">
		<xsl:param name="date"/>
		<xsl:choose>
			<!-- pivmrvli -->
			<xsl:when test="contains($date,'..')">
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="substring-before ($date,'..')"/>
				</xsl:call-template>
				<xsl:text> - </xsl:text>
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="substring-after ($date,'..')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- pivmr -->
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="$date"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="datesingle">
		<xsl:param name="pdatesingle"/>
		<!-- pp-->
		<xsl:if test='substring ($pdatesingle, 7, 2)!=""'>
			<xsl:value-of select="format-number(substring ($pdatesingle,7, 2),0)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- kk-->
		<xsl:if test='substring ($pdatesingle, 5, 2)!=""'>
			<xsl:value-of select="format-number(substring ($pdatesingle,5, 2),0)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- vvvv-->
		<xsl:value-of select="substring ($pdatesingle, 1, 4)"/>
		<xsl:text/>
		<xsl:if test='substring ($pdatesingle, 9, 2)!=""'>
			<xsl:text> klo </xsl:text>
			<!-- hh-->
			<xsl:value-of select="substring ($pdatesingle,9, 2)"/>
		</xsl:if>
		<!-- mm -->
		<xsl:if test='substring ($pdatesingle, 11, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,11, 2)"/>
		</xsl:if>
		<!-- ss -->
		<xsl:if test='substring ($pdatesingle, 13, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,13, 2)"/>
		</xsl:if>
	</xsl:template>
	<!-- 	Stylecode processing   
	  Supports Bold, Underline and Italics display

-->
	<xsl:template match="//n1:*[@styleCode]">
		<xsl:if test="@styleCode='Bold'">
			<xsl:element name="b">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="@styleCode='Italics'">
			<xsl:element name="i">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="@styleCode='Underline'">
			<xsl:element name="u">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Italics') and not (contains(@styleCode, 'Underline'))">
			<xsl:element name="b">
				<xsl:element name="i">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Italics'))">
			<xsl:element name="b">
				<xsl:element name="u">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Bold'))">
			<xsl:element name="i">
				<xsl:element name="u">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and contains(@styleCode, 'Bold')">
			<xsl:element name="b">
				<xsl:element name="i">
					<xsl:element name="u">
						<xsl:apply-templates/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- 	Superscript or Subscript   -->
	<xsl:template match="n1:sup">
		<xsl:element name="sup">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="n1:sub">
		<xsl:element name="sub">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
