<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- CDA R2 Ballot 3 Tyylitiedosto, HL7 Finland/TI 23.9.2004 -->
<!-- Muutoshistoria -->
<!-- 2004.12.12: Listty Sovittujen Header-elementtien muotoilu katseltaviksi. -->
<!-- 2004.12.12: Listty content-elementin attribuutin revised-ksittely. Eli lisykset ja poistot merkitn.-->
<!-- 2004.09.28: Listty xsl:output lause, jossa sanotaan merkkivalikoimaksi ISO-8859-1. -->
<!-- Muista pivitt tyylitiedoston versio html-head tagin jlkeen -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:hl7fi="urn:hl7finland" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
	<!-- CDA document -->
	<xsl:template match="/">
		<xsl:apply-templates select="n1:ClinicalDocument"/>
	</xsl:template>
	<xsl:template match="n1:ClinicalDocument">
		<html>
			<head/>
			<style>
				<xsl:comment>				
					 .class-normal {  font-style: normal; font-weight: normal; }
					 .class-bold {  font-style: normal; font-weight: bold; }
					 .class-underline { font-style: normal; font-weight: normal; text-decoration: underline; }
					 .class-italics { font-style: italic; font-weight: normal; }
					 .class-emphasis {  font-style: normal; font-weight: normal; background-color:yellow; }
					 .class-delete {  font-style: normal; font-weight: normal; text-decoration:line-through; }
					 .class-insert {  font-style: normal; font-weight: normal; text-decoration:underline; }
					 .class-caption {  font-style: normal; font-weight: bold;  }
	          	</xsl:comment>
			</style>
			<xsl:comment>				
              HL7 Finland  R2 Tyylitiedosto: Open CDA_2005
            </xsl:comment>
			<body>
				<xsl:apply-templates select="n1:realmCode"/>
				<xsl:apply-templates select="n1:typeId"/>
				<xsl:apply-templates select="n1:id"/>
				<xsl:apply-templates select="n1:code"/>
				<xsl:apply-templates select="n1:title"/>
				<xsl:apply-templates select="n1:effectiveTime"/>
				<xsl:apply-templates select="n1:confidentialityCode"/>
				<xsl:apply-templates select="n1:languageCode"/>
				<xsl:apply-templates select="n1:setId"/>
				<xsl:apply-templates select="n1:versionNumber"/>
				<xsl:apply-templates select="n1:author"/>
				<xsl:apply-templates select="n1:custodian"/>
				<xsl:apply-templates select="n1:componentOf"/>
				<xsl:apply-templates select="hl7fi:localHeader"/>
				<xsl:apply-templates select="n1:recordTarget"/>
				<br/>
				<xsl:apply-templates select="n1:component/n1:structuredBody"/>
			</body>
		</html>
	</xsl:template>
	<!-- 01 Asiakirjan aluekoodi -->
	<xsl:template match="n1:ClinicalDocument/n1:realmCode">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<h3>
					<xsl:text>CDA R2 tuloste (Open CDA 2005 CDA_Fi.xsl 2006-02-28)</xsl:text>
				</h3>
				<xsl:text>01 Asiakirjan aluekoodi: </xsl:text>
			</span>
			<xsl:value-of select="@code"/>
			<br/>
		</em>
	</xsl:template>
	<!-- 02 Asiakirjan tyyppi -->
	<xsl:template match="n1:ClinicalDocument/n1:typeId">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>02 Asiakirjan tyyppi: </xsl:text>
			</span>
			<xsl:value-of select="@root"/>
			<xsl:choose>
				<xsl:when test="@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</em>
	</xsl:template>
	<!-- 04 Asiakirjan OID-tunnus -->
	<xsl:template match="n1:ClinicalDocument/n1:id">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>04 Asiakirjan OID-tunnus: </xsl:text>
			</span>
			<xsl:value-of select="@root"/>
			<xsl:choose>
				<xsl:when test="@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</em>
	</xsl:template>
	<!-- 05 Asiakirjan code -->
	<xsl:template match="n1:ClinicalDocument/n1:code">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>05 Erilln pidettv rekisteri: </xsl:text>
			</span>
			<xsl:value-of select="@displayName"/>
			<xsl:value-of select="@root"/>
			<xsl:choose>
				<xsl:when test="@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</em>
	</xsl:template>
	<!-- 06 Asiakirjan title -->
	<xsl:template match="n1:ClinicalDocument/n1:title">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>06 Asiakirjan otsake: </xsl:text>
			</span>
			<xsl:value-of select="."/>
			<br/>
		</em>
	</xsl:template>
	<!-- 07 effectiveTime -->
	<xsl:template match="n1:effectiveTime">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>07 Asiakirjan luontipiv: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="@value"/>
			</xsl:call-template>
			<br/>
		</em>
	</xsl:template>
	<!-- 8. Asiakirjan luottamuksellisuus  pakollinen tytetn aina N -->
	<xsl:template match="n1:confidentialityCode">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>08 Turvaluokittelu: </xsl:text>
			</span>
			<xsl:value-of select="@code"/>
			<xsl:text>, </xsl:text>
			<xsl:value-of select="@displayName"/>
			<br/>
		</em>
	</xsl:template>
	<!-- 9. Asiakirjan kieli pakollinen-->
	<xsl:template match="n1:languageCode">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>09 Asiakirjan kieli: </xsl:text>
			</span>
			<xsl:value-of select="@code"/>
			<br/>
		</em>
	</xsl:template>
	<!-- 10 Alkuperisen asiakirjan OID-tunnus -->
	<xsl:template match="n1:setId">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>10 Alkuperisen asiakirjan OID-tunnus: </xsl:text>
			</span>
			<xsl:value-of select="@root"/>
			<xsl:choose>
				<xsl:when test="@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</em>
	</xsl:template>
	<!-- 11 Asiakirjan versio -->
	<xsl:template match="n1:versionNumber">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>11 Asiakirjan versio: </xsl:text>
			</span>
			<xsl:value-of select="@value"/>
			<br/>
		</em>
	</xsl:template>
	<!-- 17 custodian -->
	<xsl:template match="n1:custodian">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>17 Rekisterinpitj: </xsl:text>
			</span>
			<xsl:value-of select="n1:assignedCustodian/n1:representedCustodianOrganization/n1:name"/>
			<br/>
		</em>
	</xsl:template>
	<!-- 26 componentOf hoitopaikat ja hoitoajat -->
	<xsl:template match="n1:componentOf">
		<br/>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>26 Palveluluokka: </xsl:text>
			</span>
			<xsl:value-of select="n1:encompassingEncounter/n1:code/@displayName"/>
			<br/>
		</em>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>26 Kokonaishoitoaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:encompassingEncounter/n1:effectiveTime/n1:low/@value"/>
			</xsl:call-template>
			<xsl:text> - </xsl:text>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:encompassingEncounter/n1:effectiveTime/n1:high/@value"/>
			</xsl:call-template>
			<br/>
		</em>
		<xsl:for-each select="n1:encompassingEncounter/n1:encounterParticipant">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>26 Osaston hoitoaika: </xsl:text>
				</span>
				<xsl:call-template name="date">
					<xsl:with-param name="date" select="n1:time/n1:low/@value"/>
				</xsl:call-template>
				<xsl:text> - </xsl:text>
				<xsl:call-template name="date">
					<xsl:with-param name="date" select="n1:time/n1:high/@value"/>
				</xsl:call-template>
				<span style="font-weight:bold; color:green;">
					<xsl:text> toimipaikka: </xsl:text>
				</span>
				<xsl:value-of select="n1:assignedEntity/n1:representedOrganization/n1:name"/>
				<br/>
			</em>
		</xsl:for-each>
	</xsl:template>
	<!-- 14 author -->
	<xsl:template match="n1:author">
		<br/>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>14 Hoidon alkuaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:time/@value"/>
			</xsl:call-template>
			<br/>
		</em>
		<xsl:choose>
			<xsl:when test="n1:assignedAuthor/n1:assignedPerson/n1:name">
				<em class="class-caption">
					<span style="font-weight:bold; color:green;">
						<xsl:text>14 Asiakirjan laatija: </xsl:text>
					</span>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:suffix"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family"/>
					<br/>
				</em>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="n1:assignedAuthor/n1:representedOrganization/n1:name">
				<em class="class-caption">
					<span style="font-weight:bold; color:green;">
						<xsl:text>14 Asiakirjan laatijan toimipaikka: </xsl:text>
					</span>
					<xsl:value-of select="n1:assignedAuthor/n1:representedOrganization/n1:name"/>
					<br/>
				</em>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- 13 recordTarget potilaan tiedot -->
	<xsl:template match="n1:recordTarget">
		<em class="class-caption">
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>13 Potilaan henkiltunnus: </xsl:text>
			</span>
			<xsl:value-of select="n1:patientRole/n1:id/@extension"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>13 Potilaan nimi: </xsl:text>
			</span>
			<xsl:value-of select="n1:patientRole/n1:patient/n1:name/n1:family"/>
			<xsl:text>, </xsl:text>
			<xsl:value-of select="n1:patientRole/n1:patient/n1:name/n1:given"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>13 Potilaan sukupuoli: </xsl:text>
			</span>
			<xsl:value-of select="n1:patientRole/n1:patient/n1:administrativeGenderCode/@code"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>13 Potilaan syntymaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="n1:patientRole/n1:patient/n1:birthTime/@value"/>
			</xsl:call-template>
			<br/>
		</em>
	</xsl:template>
	<!-- Local Header -->
	<!-- FI 1 hl7fi:description - asiakirjan kuvaus -->
	<xsl:template match="hl7fi:localHeader">
		<br/>
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>01 hl7fi kuvaus: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:description"/>
			<br/>
		</em>
		<!-- FI 2 hl7fi:tableOfContents - asiakirjan sisllysluettelo -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>02 hl7fi:lomakkeet: </xsl:text>
			</span>
		</em>
		<xsl:for-each select="hl7fi:tableOfContents/hl7fi:contentsCode/@displayName">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>...</xsl:text>
				</span>
				<xsl:value-of select="."/>
			</em>
		</xsl:for-each>
		<br/>
		<!-- FI 3 hl7fi:registratedTime - asiakirjan rekiterintiaika -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>03 hl7fi:rekisterintiaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="hl7fi:registratedTime"/>
			</xsl:call-template>
			<br/>
		</em>
		<!-- FI 4 hl7fi:declaredTime - asiakirjan arkistointiaika -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>04 hl7fi:arkistointiaika: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="hl7fi:declaredTime"/>
			</xsl:call-template>
			<br/>
		</em>
		<!-- FI 5 hl7fi:typeCode - asiakirjan laji -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>05 hl7fi:laji: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:typeCode/@displayName"/>
			<br/>
		</em>
		<!-- FI 6 hl7fi:fileFormat - asiakirjan tiedostomuoto -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>06 hl7fi:tiedostomuoto: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:fileFormat"/>
			<br/>
		</em>
		<!-- FI 7 hl7fi:softwareSupport - asiakirjan tuottanut ohjelmisto -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>07 hl7fi:tuottanut ohjelmisto: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:softwareSupport"/>
			<br/>
		</em>
		<!-- FI 8 hl7fi:hasPartOfId - hoitojakson asiakirjatunnus -->
		<xsl:for-each select="hl7fi:hasPartOfId">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>08 hl7f:hoitojakson asiakirjatunnus: </xsl:text>
				</span>
				<xsl:value-of select="@root"/>
				<xsl:choose>
					<xsl:when test="@extension">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@extension"/>
					</xsl:when>
				</xsl:choose>
				<br/>
			</em>
		</xsl:for-each>
		<!-- FI 9 hl7fi:documentTypeCode - asiakirjan tyyppi -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>09 hl7fi:asiakirjan tyyppi: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:documentTypeCode/@displayName"/>
			<br/>
		</em>
		<!-- FI 10 hl7fi:currentLocation - asiakirjan tilapinen sijoitus -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>10 hl7fi:asiakirjan tilapinen sijoitus: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:currentLocation"/>
			<br/>
		</em>
		<!-- FI 11 hl7fi:retentionPeriodTime - asiakirjan silytysajan pituus -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>11 hl7fi:asiakirjan silytysajan pituus: </xsl:text>
			</span>
			<xsl:call-template name="date">
				<xsl:with-param name="date" select="hl7fi:retentionPeriodTime"/>
			</xsl:call-template>
			<br/>
		</em>
		<!-- FI 12 hl7fi:functionCode - asiakirjan tehtvtunnus (AMS) -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>12 hl7fi:asiakirjan tehtvtunnus (AMS): </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:functionCode/@displayName"/>
			<br/>
		</em>
		<!-- FI 13 hl7fi:recordStatusCode - asiakirjan valmistumisen tila -->
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>13 hl7fi:asiakirjan valmistumisen tila: </xsl:text>
			</span>
			<xsl:value-of select="hl7fi:recordStatusCode/@displayName"/>
			<br/>
		</em>
		<!-- FI 14 hl7fi:auditTrail - asiakirjan ksiottelyhistoria -->
		<xsl:for-each select="hl7fi:auditTrail">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>14 hl7fi:muutoslaji: </xsl:text>
				</span>
				<xsl:value-of select="hl7fi:auditTrailCode/@displayName"/>
				<span style="font-weight:bold; color:green;">
					<xsl:text> saika: </xsl:text>
				</span>
				<xsl:call-template name="date">
					<xsl:with-param name="date" select="hl7fi:auditTrailTime"/>
				</xsl:call-template>
				<span style="font-weight:bold; color:green;">
					<xsl:text> objekti: </xsl:text>
				</span>
				<xsl:value-of select="hl7fi:auditTrailId/@root"/>
					<xsl:text> - </xsl:text>
				<xsl:value-of select="hl7fi:auditTrailIdEnd/@root"/>
				<br/>
			</em>
		</xsl:for-each>
		<!-- FI 15 hl7fi:serviceChainLink - asiakirjan linkit palveluketjuihin -->
		<xsl:for-each select="hl7fi:serviceChainLink">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>15 hl7fi:palveluketjutunnus: </xsl:text>
				</span>
				<xsl:value-of select="hl7fi:serviceChainLinkId/@root"/>
				<xsl:choose>
					<xsl:when test="hl7fi:serviceChainLinkId/@extension">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="hl7fi:serviceChainLinkId/@extension"/>
					</xsl:when>
				</xsl:choose>
				<xsl:text>  </xsl:text>
				<xsl:value-of select="hl7fi:serviceChainLinkName"/>
				<br/>
			</em>
		</xsl:for-each>
		<!-- FI 16 hl7fi:episodeLink Asiakirjan linkit hoitokokonaisuuksiin -->
		<xsl:for-each select="hl7fi:episodeLink">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>16 hl7fi:hoitokonaisuustunnus: </xsl:text>
				</span>
				<xsl:value-of select="hl7fi:episodeLinkId/@root"/>
				<xsl:choose>
					<xsl:when test="hl7fi:episodeLinkId/@extension">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="hl7fi:episodeLinkId/@extension"/>
					</xsl:when>
				</xsl:choose>
				<xsl:text>  </xsl:text>
				<xsl:value-of select="hl7fi:episodeLinkName"/>
				<br/>
			</em>
		</xsl:for-each>
		<!-- FI 17 hl7fi:product - asiakirjan toimittajan alue -->
		<xsl:for-each select="hl7fi:product">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>17 hl7fi:tuotealue: </xsl:text>
				</span>
				<xsl:choose>
					<xsl:when test="@moderator">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@moderator"/>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="@product">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@product"/>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="@version">
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@version"/>
					</xsl:when>
				</xsl:choose>
				<br/>
			</em>
		</xsl:for-each>
		<!-- FI 18 hl7fi:signature - asiakirjan shkiset allekirjoitustiedot -->
		<xsl:for-each select="hl7fi:signature">
			<em class="class-caption">
				<span style="font-weight:bold; color:green;">
					<xsl:text>18 hl7fi:shkinen allekirjoitus: </xsl:text>
				</span>
				<xsl:value-of select="n1:SignedInfo/n1:Reference/@URI"/>
				<br/>
			</em>
		</xsl:for-each>
	</xsl:template>
	<!-- StructuredBody -->
	<xsl:template match="n1:component/n1:structuredBody">
		<xsl:apply-templates select="n1:component/n1:section"/>
	</xsl:template>
	<!-- Component/Section -->
	<xsl:template match="n1:component/n1:section">
		<xsl:apply-templates select="n1:title"/>
		<ul>
			<xsl:apply-templates select="n1:text"/>
			<xsl:apply-templates select="n1:component/n1:section"/>
		</ul>
	</xsl:template>
	<!--   Title  -->
	<xsl:template match="n1:title">
		<span style="font-weight:bold; color:green;">
			<xsl:value-of select="."/>
		</span>
	</xsl:template>
	<!--   Text   -->
	<xsl:template match="n1:text">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="n1:text/n1:br">
		<br/>
	</xsl:template>
	<!--   paragraph  -->
	<xsl:template match="n1:paragraph">
		<xsl:apply-templates/>
		<br/>
	</xsl:template>
	<!--   content  -->
	<xsl:template match="n1:content">
		<xsl:choose>
			<xsl:when test='@revised="delete"'>
				<em class="class-delete">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="insert"'>
				<em class="class-insert">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Bold"'>
				<em class="class-bold">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Underline"'>
				<em class="class-underline">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Italics"'>
				<em class="class-italics">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Emphasis"'>
				<em class="class-emphasis">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--   list  -->
	<xsl:template match="n1:list">
		<!--   listan otsikko  -->
		<xsl:if test="n1:caption">
			<span style="font-weight:bold; ">
				<xsl:apply-templates select="n1:caption"/>
			</span>
		</xsl:if>
		<!-- Jokainen listan alkio -->
		<xsl:for-each select="n1:item">
			<li>
				<!-- Lista-alkion elementti-->
				<xsl:apply-templates/>
			</li>
		</xsl:for-each>
	</xsl:template>
	<!--   caption  -->
	<xsl:template match="n1:caption">
		<xsl:apply-templates/>
		<xsl:text>: </xsl:text>
	</xsl:template>
	<!--      Tables
	 Koko alipuu kopioidaan sellaisenaan.
	 CAPTION elementin lapset ksitelln mahdollisilla muilla templateilla
  -->
	<xsl:template match="n1:table|n1:table/n1:caption|n1:thead|n1:tfoot|n1:tbody|n1:colgroup|n1:col|n1:tr|n1:th|n1:td">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/n1:caption">
		<span style="font-weight:bold; ">
			<xsl:apply-templates/>
		</span>
	</xsl:template>
	<!-- Nimen tulostaminen -->
	<xsl:template name="getName">
		<xsl:apply-templates select="n1:name"/>
	</xsl:template>
	<!-- Pivmrn ja kellonajan tai -vlien muotoilu ulkoasuun pp.kk.vvvv klo hh:mm:ss -->
	<xsl:template name="date">
		<xsl:param name="date"/>
		<xsl:choose>
			<!-- pivmrvli -->
			<xsl:when test="contains($date,'..')">
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="substring-before ($date,'..')"/>
				</xsl:call-template>
				<xsl:text> - </xsl:text>
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="substring-after ($date,'..')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- pivmr -->
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="$date"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="datesingle">
		<xsl:param name="pdatesingle"/>
		<!-- pp-->
		<xsl:if test='substring ($pdatesingle, 7, 2)!=""'>
			<xsl:value-of select="format-number(substring ($pdatesingle,7, 2),0)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- kk-->
		<xsl:if test='substring ($pdatesingle, 5, 2)!=""'>
			<xsl:value-of select="format-number(substring ($pdatesingle,5, 2),0)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- vvvv-->
		<xsl:value-of select="substring ($pdatesingle, 1, 4)"/>
		<xsl:text/>
		<xsl:if test='substring ($pdatesingle, 9, 2)!=""'>
			<xsl:text> klo </xsl:text>
			<!-- hh-->
			<xsl:value-of select="substring ($pdatesingle,9, 2)"/>
		</xsl:if>
		<!-- mm -->
		<xsl:if test='substring ($pdatesingle, 11, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,11, 2)"/>
		</xsl:if>
		<!-- ss -->
		<xsl:if test='substring ($pdatesingle, 13, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,13, 2)"/>
		</xsl:if>
	</xsl:template>
	<!-- 	Stylecode processing   
	  Supports Bold, Underline and Italics display

-->
	<xsl:template match="//n1:*[@styleCode]">
		<xsl:if test="@styleCode='Bold'">
			<xsl:element name="b">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="@styleCode='Italics'">
			<xsl:element name="i">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="@styleCode='Underline'">
			<xsl:element name="u">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Italics') and not (contains(@styleCode, 'Underline'))">
			<xsl:element name="b">
				<xsl:element name="i">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Italics'))">
			<xsl:element name="b">
				<xsl:element name="u">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Bold'))">
			<xsl:element name="i">
				<xsl:element name="u">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and contains(@styleCode, 'Bold')">
			<xsl:element name="b">
				<xsl:element name="i">
					<xsl:element name="u">
						<xsl:apply-templates/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- 	Superscript or Subscript   -->
	<xsl:template match="n1:sup">
		<xsl:element name="sup">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="n1:sub">
		<xsl:element name="sub">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
